## 概述

中科时代HyperCare（曾用名：SF8010 Device Manager ）V2.1.3.0是⼀款设备管理⼯具软件产品，用于管理整个工智机系统，包括系统信息、硬件信息读取以及二次分配功能。本手册主要介绍HyperCare中各个模块的功能及其基本使用方法。


---
操作演示视频

HyperCare操作演示视频
[![](https://resource.helplook.net/docker_production/3648ne/article/XIJ9paUq/686dcb8d79ebb.png)](https://www.bilibili.com/video/BV13UqAYtENq?t=36.8)

---

下表概述了各个产品组件

| **产品组件**          | **描述说明**                                                                                                                 |
| ----------------- | ------------------------------------------------------------------------------------------------------------------------ |
| `sf8010`本模块（核心模块） | `sf8010` 是 SF8010 设备管理工具的核心组件，负责工智机系统的全面管理。它可以监控设备的运行状态、管理硬件资源。该组件提供了丰富的系统和硬件信息读取功能，支持用户通过图形界面或命令行进行二次配置，确保设备始终处于最佳运行状态。 |
| `libacp`依赖模块      | `libacp` 是一个提供访问控制协议（ACP）功能的库文件。它支持数据加密、安全认证以及访问控制。该组件通常用于确保设备和系统之间的数据交换是安全的，防止未经授权的访问。                                  |
| `adi-service`依赖模块 | `adi-service` 是设备接口的服务组件，主要用于驱动和管理硬件设备。它负责设备的初始化、配置和数据传输，同时提供与其他系统组件的连接和通信服务。该组件在系统启动时自动加载并运行，以确保硬件设备与操作系统的正确协同工作。       |
| `aoiservice`依赖模块  | `aoiservice` 是一个自动化操作接口服务，提供对设备进行自动配置、监控和管理的功能。它可以根据预设条件自动执行操作、诊断设备问题，或者在故障发生时提供相关日志。该组件对于大规模设备管理尤为重要，能够提高工作效率并减少人工干预。   |



## 安装卸载

### 一、软件下载

请在中科时代资源下载中心，下载最新版的文件（以网站提供的实际版本为准），包含的文件列表如下：
[HyperCare V2.1.3下载地址：](https://sinsegye-prod.oss-cn-beijing.aliyuncs.com/metafacture/DONTREMOVE/for_onlinehelp/sf8010_2.1.3.0.zip?OSSAccessKeyId=LTAI5t8g93YQ2feTaJveaZmg&Expires=2114625689&Signature=54ZegH1vjbLb%2F7C7pto6YxMlhaY%3D)

* libacp\_0.2.3\_amd64.deb

* aoiservice\_1.0.5\_amd64.deb

* adi-service\_1.4.1\_amd64.deb

* sf8010\_2.1.3.0\_amd64.deb

* ivshmem\_0.3.1\_amd64.deb

* sjournal\_1.4.0\_amd64.deb

* sosreport\_0.0.8\_amd64.deb

### 二、安装过程

```bash
# 将下载的deb包，上传到⼯智机后，执⾏如下命令
cd ~/downloads  # 进入安装包所在的目录
sudo dpkg -i ./{package_name}.deb
# 操作皆为 sudo dpkg -i 文件路径（以deb包实际路径和名称为准）
#重复操作将这些deb包安装后重启设备
# 也可以按照如下操作:
sudo dpkg -l ./libacp_0.2.3_amd64.deb ./ivshmem_0.3.1_amd64.deb ./sosreport_0.0.8_amd64.deb ./sjournal_1.4.0_amd64.deb ./adi-service_1.4.1_amd64.deb ./aoiservice_1.0.5_amd64.deb ./sf8010_2.1.3.0_amd64.deb

sudo reboot#重启代码
```

> 安装顺序：最后安装8010即可

### 三、更新安装

更新和安装操作相同，新版将自动覆盖



## 功能介绍

### **1、登录**

1.1 打开浏览器，输入工智机的 IP 地址+【:8010】，并按【回车键】。页面将自动跳转至登录界面。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/689568425fc81.png)



1.2 在登录页面，输入您的【用户名】和【密码】，然后点击【登录】按钮即可。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/6895684df3c0e.png)

> **提示：**
> 请妥善保管用户名和密码等敏感信息。如需获取相关支持，详情请见文末“中科时代产品的本地支持与服务”部分。



### **2、设备概览**

#### **2.1 适用范围**

适用于所有已适配的机型。

#### **2.2 功能简介**

该页面用于展示设备的实时域和非实时域信息，包括主机名称、机器型号、IP 地址等基本信息，以及系统运行状态下的 CPU、内存和存储的温度和占用情况。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956855d1366.png)


#### **2.3 使用详情**

**a. 基本信息：**&#x663E;示主机的机器型号、存储大小、序列号、CPU 核数、内存大小、主机名称、IP 地址、Cmos 电池电压。鼠标放置在【i】图标上可查看详细信息。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/6895685b66eed.png)


> Cmos 电池电压只有 SX5820-0001 和 SX5820-0002 显示

**b. 工智机资源监控：**&#x56FE;表展示实时域的 CPU 使用率、温度及内存使用率和存储占用。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956860ee873.png)


**c. 虚拟机资源监控：**&#x56FE;表展示非实时域的 CPU 使用率、内存使用率和存储占用。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956865c4d92.png)


> 只有 SP7010-1211、SP7020-2231、SP7022-2231、SP5040-4331、SP5040-3331、SX2133 二型有虚拟机资源监控模块



### **3、硬件配置-网口配置**

#### **3.1 适用范围**

适用于所有已适配的机型。

#### **3.2 功能简介**

该页面用于查看实时域中的网卡信息，并支持对网卡进行 EtherCAT、IP、DNS、路由等自定义配置。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956870a6c79.png)


#### **3.3 使用详情**

##### **3.3.1 网口信息**

通过点击左边列表的【硬件配置】→【网口配置】，打开网口信息列表，查看 LAN 名称、网卡名称、MAC 地址、IP 地址、网口类型等详细信息。点击【设置】按钮可对相应网卡进行配置修改。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/689568e405b11.png)


部分机型可以查看扩展网卡信息
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/6895690759e08.png)


##### **3.3.2 EtherCAT 状态-启用**

> 请确保网线已正确连接：工智机、伺服设备和局域网应按照实际需求正确连接。

a. 点击需要修改配置的网卡对应的【设置】按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/6895698a675da.png)

b. 点击【配置模式和参数】按钮
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956994c8412.png)


c. 选择工作模式为【EtherCAT（工业以太网）】
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/6895699b0332d.png)


d. 选择【EtherCAT 内核】的核数。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/689569a0f0227.png)


e. 完成配置后，点击【确定】按钮以使修改生效。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/689569a5d851a.png)


> &#x20;LAN1 网卡为管理口，不能进行 EtherCAT 配置。

##### **3.3.3 EtherCAT 状态-禁用**

a. 点击已设置【EtherCAT 网卡】的【设置】按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/689569ac17ebc.png)


b. 点击【配置模式和参数】按钮
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/689569b250320.png)


c. 选择工作模式为【Ethernet（以太网）】，IP 默认设置为自动，也可手动配置 IP。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/689569b864cb6.png)


d. 完成配置后，点击【确定】按钮以使修改生效。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/689569c36c924.png)


##### **3.3.4 IP 配置-自动**

a. 点击需要修改配置的网卡对应的【设置】按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/689569e3758cc.png)


b. 点击【配置模式和参数】按钮
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/689569ea10a73.png)


c. 修改【IPv4 方式】为【自动】（默认设置）。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/689569ee995e9.png)


d. 完成配置后，点击【确定】按钮以使修改生效。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/689569f39e65a.png)


##### **3.3.5 IP 配置-手动**

a. 点击需要修改配置的网卡对应的【设置】按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/689569fbb99af.png)


b. 点击【配置模式和参数】按钮
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a0078737.png)


c. 修改【IPv4 方式】为【手动】，系统会显示网关、IP 地址、子网掩码配置项。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a0668118.png)


d. 根据现场需求，设置网关、IP 地址和子网掩码。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a0d101e9.png)


e. 点击下方的【⊕添加】按钮，创建新的路由条目。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a36574a4.png)


f. 完成配置后，点击【确定】按钮以使修改生效。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a3019795.png)


> 注意 IP 地址格式和配置的准确性。

##### **3.3.6 IP 配置-禁用**

a. 点击需要修改配置的网卡对应的【开关】按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a3e437db.png)


##### **3.3.7 DNS 设置**

a. 点击需要修改配置的网卡对应的【设置】按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a43ed7cc.png)


b. 点击【配置模式和参数】按钮
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a499f3eb.png)


c. 点击【DNS】
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a4de302e.png)


d. 在文本框中根据现场需求填写相应配置。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a53d9a92.png)


e. 完成配置后，点击【确定】按钮以使修改生效。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a58aad85.png)


> &#x20;注意 DNS 格式和配置的准确性。

##### **3.3.8 路由设置**

a. 点击需要修改配置的网卡对应的【设置】按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a74e3ead.png)

b. 点击【配置模式和参数】按钮
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a7b434a0.png)

c. 点击【路由设置】按钮
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a818e4f0.png)


d. 点击【⊕添加】按钮，创建新的路由条目。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a863b562.png)


e. 在文本框中根据现场需求填写【地址】、【子网掩码】、【网关】、【跃点】配置项。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a8b886a4.png)


f. 完成配置后，点击【确定】按钮以使修改生效。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a91de1a3.png)


> 注意 IP 地址格式和配置的准确性。

##### **3.3.9 删除配置**

a. 点击需要修改配置的网卡对应的【设置】按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a987d05b.png)


b. 点击已配置的IP或路由项旁的【🗑】图标。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956a9e98d30.png)
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956aa31a9ac.png)


c. 完成配置后，点击【确定】按钮以使修改生效。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956aa79b99f.png)


### **4、硬件配置-串口配置**

#### **4.1 适用范围**

| SX58 系列     | SX51XX-10XX 系列 | SX51XX-11XX 系列 | SX51XX-20XX 系列 | SX2 系列    |
| ----------- | -------------- | -------------- | -------------- | --------- |
| SX5820-0001 | SX5132-10XX    | SX5132-11XX    | SX5132-20XX    | SX2133 一型 |
| SX5820-0002 | SX5164-10XX    | SX5164-11XX    | SX5164-20XX    | SX2133 二型 |
|             | SX5100-10XX    | SX5100-11XX    | SX5100-20XX    |           |

#### **4.2 功能简介**

该功能用于查看和修改实时域的串口模式。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956ab229ebf.png)


#### **4.3 使用详情**

##### **4.3.1 串口切换**

点击左侧列表的【硬件配置】→ 【串口配置】，根据现场实际需求选择对应的串口类型【485/422/232】。配置修改完成后，一定要点击【修改】按钮才能生效。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956ab8f323e.png)


##### **4.3.2 注意事项**

* 请在非生产环境下进行配置。

### &#x35;**、硬件配置-PCIE 配置**

#### **5.1 适用范围**

| SP 系列       | SX2 系列    |
| ----------- | --------- |
| SP7010-1211 | SX2133 二型 |
| SP7020-2231 |           |
| SP7022-2231 |           |
| SP5040-4331 |           |
| SP5040-3331 |           |

#### **5.2 功能简介**

该功能用于配置内置或扩展的 PCIE 设备域的设置。

#### **5.3 使用详情**

##### **5.3.1 主页面**

点击左侧列表的【硬件配置】 → 【PCIE 配置】，进入 PCIE 配置页面。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956ac114f4d.png)


> SP7010-1211 和 SP7020-2231 仅支持内置 PCIE 配置；SP5040-3331仅支持扩展 PCIE 配置；SX2133 二型、SP7022-2231 和 SP5040-4331 同时支持内置 PCIE 和扩展 PCIE 配置。

##### **5.3.2 内置 PCIE**

a. 内置 PCIE 列表展示工智机已集成的内置网卡。用户可以通过修改域配置，选择对应网卡在非实时域（Windows）或实时域（Linux）下使用。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956ac642f29.png)


b. 内置 PCIE 列表中的设备与物理网口的对应关系可以通过以下方式查看：
点击设备序号前的【+】按钮，展开详情，查看该设备对应的 LANx
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956aded11f8.png)
根据 LANx，返回【⽹⼝配置】⻚⾯，查看⽹⼝信息中的对应关系（也可以与物理设备上印刷的 LANx 直接对应）。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b161f9ef.png)

c. 选择要配置的网卡，点击下拉框，修改域配置为【实时域】或【非实时域】。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b1b43259.png)


d. 完成配置修改后，点击【设置】按钮，弹出提示窗口。点击【取消】将取消 PCIE 修改，点击【确认】后，需要手动将设备重启，此时 PCIE 状态变为【等待断电重启】。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b21f1943.png)

![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b2737820.png)


> 建议立即重启，若不立即重启，可能会出现潜在问题。

e. 重启工智机后，状态将显示为【正常】。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b36936cc.png)


f. 当域配置为【非实时域】时，对应网口信息中类型显示为【虚拟网卡】，该网卡应用于非实时域（Windows），若要进行配置，需要到 Windows 下执行相关操作，SF8010 网页不再支持配置。

> 设置 EtherCAT 的网卡域配置时，修改到非实时域后，再次修改为实时域时，该网卡将变为【禁用】状态。如需使用该网卡，需要在网口配置中重新设置。

##### **5.3.3 扩展 PCIE**

> **SX2133 二型**已验证可扩展模块：四网口模块、串口/CAN 模块、解码模块（多个拓展连接，解码模块需放到最后）。
> **SP7022-2231&#x20;**&#x5DF2;验证可扩展模块：P1000 显卡、RTX 3060 显卡、2 口 422/485 串口卡、4 网口网卡、6 网口网卡、GT 730 显卡、PCIe-9110I CAN 卡。
>
> **SP5040-3331&#x20;**&#x5DF2;验证可扩展模块：P1000 显卡、RTX 3060 显卡、RTX 3080 显卡、RTX 4060 显卡、4 网口网卡、6 网口网卡、GT 730 显卡、PCI 网口卡、PCI 串口卡。
>
> **SP5040-4331&#x20;**&#x5DF2;验证可扩展模块：P1000 显卡、RTX 3060 显卡、RTX 3080 显卡、RTX 4060 显卡、2 口 422/485 串口卡、4 网口网卡、6 网口网卡、GT 730 显卡、PCIe-9110I CAN 卡、PCI CAN卡、PCI 网口卡、PCI 串口卡。

a. 扩展 PCIE 列表展示工智机外接的设备（未接入设备时，该列表默认为空）。扩展 PCIE 模块的插拔需在设备断电下操作。接入设备后，设备将出现在扩展 PCIE 列表中，首次接入的设备默认域配置为【非实时域】。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b3fa7852.png)


b. 用户可以通过修改域配置，选择对应网卡在非实时域（Windows）或实时域（Linux）下使用。

c. 选择已接入的扩展设备，点击下拉框，修改域配置。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b45c5f65.png)


d. 完成配置修改后，点击【设置】按钮，弹出确认提示窗口。点击【取消】将取消 PCIE 修改，点击【确认】后，设备需手动重启（重启具体操作方式：8.3.7 实时域重启，PCIE 状态变为【等待断电重启】。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b4ab30bc.png)
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b4f50c36.png)


> 建议立即重启，若不立即重启，可能会出现潜在问题。

e. 重启工智机后，状态将显示为【正常】。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b5715631.png)


f. 若接入已适配的显卡，工智机启动后默认从外接显卡输出显示桌面，内置集成显卡不再输出桌面（进入桌面前，集成显卡仍有输出）。

g. 若已应用在非实时域的扩展设备被从工智机拔下，再次开机后，扩展 PCIE 列表将显示该设备为【丢失设备】。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b617bdbb.png)


> 存在【丢失设备】时，需要先【清理无效设备】，然后才能进行其他设备的 PCIE 域配置。

##### **5.3.4 注意事项**

* 首次接入的扩展 PCIE 模块，默认域配置为【非实时域】。

* 若接入已适配的显卡，工智机启动后默认从外接显卡输出显示桌面，内置集成显卡不再输出桌面（进入桌面前，集成显卡仍有输出）。

* 存在【丢失设备】时，需要先清理无效设备后，再进行其他设备的 PCIE 域配置。

* 设置 EtherCAT 的网卡域配置时，修改到非实时域后，再次修改为实时域时，该网卡为【禁用】状态，若需使用该网卡，需要重新设置。

* 进行域配置修改后，建议立即重启。如果不立即重启，可能会出现潜在问题。

* 请在非生产环境下进行配置修改。



### &#x36;**、硬件配置-CPU 配置**

#### **6.1 适用范围**

适用于所有已适配的机型。

#### **6.2 功能简介**

该功能用于 CPU 分核操作。

#### **6.3 使用详情**

##### **6.3.1 主页面**

点击左侧列表的【硬件配置】→【CPU 配置】，可以查看当前 CPU 分核情况，【RT】为实时域分核，【NRT】为非实时域分核
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b7375aba.png)


##### **6.3.2 修改分核**

a. 勾选 CPU 使其用于实时域，取消勾选则使用在非实时域
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b77ca3b0.png)

> 最大可勾选 2 个核，最小可勾选 1 个——即0核必须是实时核，默认勾选

b. 完成分核后，点击【确定】按钮，系统将弹出确认提示，点击【确认】后，进入等待页面。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b7cec653.png)
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b81831ef.png)


d. 完成配置修改后，需要手动将设备重启，此时 CPU 状态变为【等待重启】。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956b876f467.png)

> 建议在修改 CPU 配置后立即重启，否则可能会出现潜在问题。

##### **6.3.3 注意事项**

* 修改 CPU 配置后，建议立即重启系统。如果不立即重启，可能会出现潜在问题。

* 请在非生产环境下进行 CPU 配置修改时谨慎操作，避免对系统稳定性产生影响。



### &#x37;**、硬件配置-内存配置**

#### &#x37;**.1 适用范围**

| SP 系列       | SX2 系列    |
| ----------- | --------- |
| SP7010-1211 | SX2133 二型 |
| SP7020-2231 |           |
| SP7022-2231 |           |
| SP5040-3331 |           |
| SP5040-4331 |           |

#### &#x37;**.2 功能简介**

该功能用于实时域和非实时域的内存使用分配管理。

#### &#x37;**.3 使用详情**

##### &#x37;**.3.1 主页面**

点击左侧列表的【硬件配置】→【内存配置】，可以查看当前内存分配情况，默认为实时域 6GB，非实时域 10GB。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956baece41e.png)


##### &#x37;**.3.2 修改内存**

a. 支持以下三种内存修改方式：
拖动蓝⾊滑块，修改内存分配。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956bba32eeb.png)
选中【⾃定义设置】后，通过输⼊数字来修改内存
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956bcff0bcf.png)
选中【⾃定义设置】后，通过点击箭头来调整内存
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956bdbabadf.png)



> 注意【**实时域最小使用内存】**&#x548C; 【**非实时域最小使用内存】** 的阈值，小于该值将无法修改内存。

b. 完成内存修改后，点击【确定】按钮，系统将弹出确认提示，点击【确认】后，进入等待页面。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956be43ac14.png)
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956be856805.png)


c. 等待页面加载完成后，将弹出重启提示窗口。可以选择直接点击【确认】按钮进行立即重启，或者点击【取消】按钮稍后重启。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956bef31036.png)


> 建议在修改内存配置后立即重启，否则可能会出现潜在问题。

##### &#x37;**.3.3 恢复出厂设置**

a. 点击【出厂设置】按钮后，再点击【确定】按钮，可以一键恢复到出厂配置。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956bf5c5d60.png)

b. 完成修改后，点击【确定】按钮，系统将弹出确认提示，点击【确认】后，进入等待页面。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956bfb20f09.png)


c. 等待页面加载完成后，将弹出重启提示窗口。可以选择点击【确认】按钮立即重启，也可以选择点击【取消】按钮稍后重启。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956bff08d8d.png)


##### &#x37;**.3.4 注意事项**

* 修改内存时，请确保【**实时域最小使用内存】**&#x548C; 【**非实时域最小使用内存】** 的阈值，小于该值将无法修改内存。

* 修改内存配置后，建议立即重启系统。如果不立即重启，可能会出现潜在问题。

* 请在非生产环境下进行内存配置修改时谨慎操作，避免对系统稳定性产生影响。

### &#x38;**、本地 IO 管理-本地 IO 模式选择**

#### &#x38;**.1 适用范围**

| SX58 系列     | SX51XX-10XX 系列 | SX51XX-11XX 系列 | SX51XX-20XX 系列 | SX2 系列    |
| ----------- | -------------- | -------------- | -------------- | --------- |
| SX5820-0001 | SX5132-10XX    | SX5132-11XX    | SX5132-20XX    | SX2133 一型 |
| SX5820-0002 | SX5164-10XX    | SX5164-11XX    | SX5164-20XX    | SX2133 二型 |
|             | SX5100-10XX    | SX5100-11XX    | SX5100-20XX    |           |

#### &#x38;**.2 功能简介**

启用此功能，本地 IO 将切换至高速模式。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956c07be72c.png)


#### &#x38;**.3 使用详情**

##### &#x38;**.3.1 主页面**

点击【本地 IO 管理】→【本地 IO 模式选择】，可以查看本地 IO 状态
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956c0ed11e6.png)


##### &#x38;**.3.2 开启本地 IO 高速模式**

a. 点击【本地 IO 高速模式】开关后，会弹出确认提示。点击【取消】按钮则不执行操作；点击【确认】将开启本地 IO 模式。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956c14a1b03.png)

##### &#x38;**.3.3 关闭本地 IO 高速模式**

a. 点击【本地 IO 高速模式】开关后，会弹出确认提示。点击【取消】按钮则不执行操作；点击【确认】将关闭本地 IO 模式。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956c1a3e115.png)




### 9、报警管理-消息中心

#### &#x39;**.1 适用范围**

适用于所有已适配的机型。

#### &#x39;**.2 功能简介**

该功能用于分类筛选、复合条件查询及顺序展示报警消息，帮助用户快速定位设备隐患，实现报警全生命周期的高效监控与处理。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956c22cd3ee.png)


#### &#x39;**.3 使用详情**

##### &#x39;**.3.1 主页面**

点击【报警管理】→【消息中心】，可以查看消息的标题、详情、类型和时间等相关信息。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956c2779f51.png)


##### &#x39;**.3.2 页签切换**

在左侧主体区域顶部选择消息分类：
【全部消息】显⽰所有消息条⽬
【未读消息】仅显⽰未读消息（带未读标识●）
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956c6674169.png)
【已读消息】仅显⽰已处理消息

##### &#x39;**.3.3 消息查询**

1. **标题内容模糊搜索**

   * 在"标题内容"输入框键入关键词（如"电压报警"）

   * 支持模糊匹配，输入后自动筛选相关消息
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956c7550f1c.png)


2. **消息类型筛选**

   * 点击"消息类型"下拉框，选择：&#x20;

     * 报警消息
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956c7ba75ea.png)


3. **时间范围筛选**

   * 日期选择器默认显示【近一周】时间段

   * 可手动选择开始时间和结束时间

   * 支持精确到秒的区间设定
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956c81a77db.png)


4. **执行操作**

   * 点击蓝色【查询】按钮应用筛选条件

   * 点击白色【重置】清空所有筛选条件
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956c88ce99b.png)


##### &#x39;**.3.4 消息管理**

1. **单条消息操作**

   * 未读消息前显示●标识
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956c9856b0f.png)


   * 点击任意消息标题后：&#x20;

     * 自动标记为已读

     * 该消息从"未读消息"页签转移至"已读消息"页签
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956ca2600ac.png)


2. **批量操作**

   * 勾选消息左侧复选框&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956caa04f6c.png)


   * 点击左下角：&#x20;

     * 【全选】选中当前页所有消息

     * 【取消全选】取消当前选择
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956cae27b88.png)


   * 选中消息后根据页签显示操作按钮：&#x20;

     * *全部消息/未读消息页签*：
       &#x20;🗑️【删除】+ ✔️【标记已读】（均需二次确认）
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956cb5845f2.png)
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956cb92e36e.png)


     * *已读消息页签*：
       &#x20;🗑️【删除】（需二次确认）
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956cbde992a.png)


##### &#x39;**.3.5 分页导航**

1. 列表底部显示分页控件：&#x20;

   * 当前页数（如第 10 页）

   * 总条目数（4622 条）
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956cc23edad.png)


   * 支持输入页码跳转
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956cc643563.png)


   * 每页可选择显示 10 条/20 条/50 条/100 条消息
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956ccad0384.png)




### 10、报警管理-消息设置

#### 1&#x30;**.1 适用范围**

适用于所有已适配的机型。

#### 1&#x30;**.2 功能简介**

该功能用于报警规则配置，支持自定义接收方式与接收周期，通过极简交互实现精准消息推送，助力企业快速响应设备异常并提升运维效率。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956cd2939e8.png)


#### 1&#x30;**.3 使用详情**

##### 1&#x30;**.3.1 主页面**

点击【报警管理】→【消息设置】
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956cd89a4e9.png)


##### **10.3.2 接收方式设置**

勾选接收方式​（当前仅支持站内消息）
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956cdd0d26d.png)


##### **10.3.3 接收周期设置**

| **选项**    | **生效规则**           |
| --------- | ------------------ |
| 每一次发生（默认） | 实时推送每次报警           |
| 每 1 小时    | 1 小时内同类型报警合并推送 1 次 |
| 每 8 小时    | 8 小时内合并推送 1 次      |
| 每一天       | 24 小时内合并推送 1 次     |
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956ce2ba25a.png)




### 11、报警管理-报警规则

#### 1&#x31;**.1 适用范围**

适用于所有已适配的机型。

#### 1&#x31;**.2 功能简介**

该功能功能通过实时监控 CPU、内存、存储及温度等关键指标，结合灵活阈值设置与连续周期判定策略，主动预警设备异常，精准规避故障风险，适用于工业设备、服务器集群及物联网终端的智能化运维场景。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956cebab961.png)


#### 1&#x31;**.3 使用详情**

##### 1&#x31;**.3.1 主页面**

左侧导航栏选择【报警管理】→【报警规则】
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956cf02fd05.png)


##### 1&#x31;**.3.2 设置连续周期**

点击下拉框选择：
`连续1/3/5/10/30个周期`（1 周期=1 分钟）
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956cf6d6282.png)


##### **11.3.3 编辑报警阈值**

点击数值输入框修改：             &#x20;

| **指标类型**    | **数值范围**  |
| ----------- | --------- |
| CPU 使用率     | 50%-100%  |
| 内存使用率       | 50%-100%  |
| 存储使用率       | 50%-100%  |
| CMOS 电池电压   | 2.2V-3.3V |
| CPU 温度（工智机） | 50-100℃   |
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956cfc688b7.png)


##### **11.3.4 启用/停用规则**

点击开关按钮切换状态：&#x20;

🔵 启⽤：符合条件时触发报警记录与消息推送
⚪ 停⽤：不执⾏报警检测与推送

### 1&#x32;**、系统配置-双域系统**

#### 1&#x32;**.1 适用范围**

适用于所有已适配的机型。

#### 1&#x32;**.2 功能简介**

该功能用于管理实时域与非实时域（桌面）系统的开机、关机、重启操作，以及展示相关的状态和信息。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d1cbdfda.png)


#### 1&#x32;**.3 使用详情**

##### 1&#x32;**.3.1 主页面**

点击【系统配置】→【双域系统】，可以查看非实时域的运行状态、主机名称、机器型号、本次启动时间等相关信息。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d223f8a0.png)


##### 1&#x32;**.3.2 非实时域重启**

a. 点击【重启桌面系统】按钮后，会弹出确认提示。点击【取消】按钮则不执行重启操作；点击【确认重启】将重启非实时域系统（桌面），实时域系统保持正常运行。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d2ef29cf.png)


> 完成操作后，等待网页自动刷新桌面状态，避免多次重复点击按钮。

##### 1&#x32;**.3.3 非实时域关机**

a. 点击【关闭桌面系统】按钮后，会弹出确认提示。点击【取消】按钮则不执行关机操作；点击【确认关闭】将关闭非实时域系统（桌面），实时域系统保持正常运行。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d3f5c897.png)


> 完成操作后，等待网页自动刷新桌面状态，避免多次重复点击按钮。

> 【关闭桌面系统】操作不会保留状态，若重启工智机，非实时域（桌面）将再次启动。

b. 等待非实时域系统（桌面）关闭后，桌面状态变为【已关闭】，并显示【启动桌面系统】按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d45efe3a.png)


##### 1&#x32;**.3.4 非实时域启动**

a. 点击【开启桌面系统】按钮后，会弹出两次确认提示。点击【取消】按钮则不执行启动操作；点击【确认开启】将启动已关闭的非实时域系统（桌面），实时域系统保持正常运行。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d4c37ab8.png)


> 完成操作后，等待网页自动刷新桌面状态，避免多次重复点击按钮。

b. 等待非实时域系统（桌面）启动后，桌面状态变为【已开启】，并显示【关闭桌面系统】按钮和【重启桌面系统】按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d50aa74e.png)


##### 1&#x32;**.3.5 非实时域关闭使能**

a. 点击【桌面使能状态】开关进行【关闭】操作后，会弹出确认提示。点击【取消】按钮则不执行关闭使能操作；点击【确认关闭】将永久关闭非实时域系统（桌面），在开启使能前不可使用。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d54eb0f4.png)


> 完成操作后，等待网页自动刷新桌面状态，避免多次重复点击按钮。

> 【桌面使能】保留状态【关闭】后，若重启工智机，非实时域（桌面）将保持关闭状态，且不会自动启动。

b. 等待桌面使能关闭后，滑块将置灰，桌面状态变为【已关闭】，并隐藏【关闭桌面系统】、【重启桌面系统】和【启动桌面系统】按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d5a550eb.png)


##### 1&#x32;**.3.6 非实时域开启使能**

a. 点击【桌面使能】滑块进行【开启】操作后，会弹出确认提示。点击【取消】按钮则不执行开启使能操作；点击【确认开启】将启动非实时域系统（桌面），并支持对其进行开机、关机、重启操作。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d5e77213.png)


> 完成操作后，等待网页自动刷新桌面状态，避免多次重复点击按钮。

> 【桌面使能】 保留状态【开启】后，若重启工智机，非实时域系统（桌面）将正常启动，并支持对其进行开机、关机和重启操作。

b. 等待桌面使能开启后，滑块将恢复开启状态，桌面状态变为【已开启】，并显示【关闭桌面系统】和【重启桌面系统】按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d70c757e.png)


##### 1&#x32;**.3.7 实时域重启**

点击【重启】按钮后，会弹出两次确认提示。点击【取消】按钮则不执行重启工智机操作；点击【确认重启】将重启整个工智机。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d7515f02.png)


> 重启整个工智机后，网页会失去连接，待工智机完全启动后，需要手动刷新网页才能恢复正常使用。

##### 1&#x32;**.3.8 实时域关机**

点击【关机】按钮后，会弹出两次确认提示。点击【取消】按钮则不执行关机操作；点击【确认关机】将关闭整个工智机。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d7b08b16.png)


##### 1&#x32;**.3.9 注意事项**

* 在开关非实时域系统过程中，不可点击【网口配置】、【PCIE 配置】、【内存配置】标签页。

* 重启整个工智机后，网页会失去连接，待工智机完全启动后，需要手动刷新网页才能恢复正常使用。

* 点击按钮后，耐心等待网页自动刷新桌面状态，避免多次重复点击按钮。



### 1&#x33;**、系统配置-文件管理**

#### 1&#x33;**.1 适用范围**

适用于所有已适配的机型。

#### 1&#x33;**.2 功能简介**

提供实时域系统文件管理功能，支持目录浏览、文件操作（上传/下载/编辑/压缩）、权限管理、批量处理等操作。

![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d8bc355c.png)


#### 1&#x33;**.3 使用详情**

##### 1&#x33;**.3.1 主页面**

点击【系统配置】→【文件管理】，可以查看实时域系统中的文件，默认显示在`/home/sinsegye`目录下。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d9abb638.png)


**刷新**：刷新当前目录内容
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956d9fafd21.png)


##### 1&#x33;**.3.2 路径切换**

a. 手动输入路径并按回车键跳转至指定目录。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956da448955.png)


b. 使用【<】按钮跳转至上级目录。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956dabbc73f.png)


##### 1&#x33;**.3.3 文件上传**

触发上传

* 点击【上传】按钮 → 选择【文件】或【文件夹】

* 支持拖拽文件/文件夹到界面触发上传
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956db0a1a3d.png)


##### **13.3.4 新建文件/文件夹**

1. **创建操作**

   * 点击【新建】→ 选择【新建文件】或【新建文件夹】

   * 自动在列表首行插入条目：&#x20;

     * 名称：`新建文件`/`新建文件夹`（立即进入编辑状态）

     * 权限：默认`755`

     * 所有者：当前登录用户（如`sinsegye`）

2. **重命名规则**

   * 直接编辑名称 → 按回车确认
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956db82f76b.png)

##### **13.3.5 批量操作**

1. **全选与操作**

   * 勾选左下角【全选】→ 显示操作栏：&#x20;

     * **下载**：打包下载选中内容（保留目录结构）

     * \*\*...\*\*：展开菜单（复制/剪切/删除/压缩/权限）
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956dbea78bb.png)


   * **粘贴逻辑**：&#x20;

     * 执行复制/剪切后，左下角显示【粘贴】按钮

     * 切换目录后点击【粘贴】完成操作
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956dc683720.png)


##### **13.3.6 分页与排序**

1. **分页设置**

   * 每页显示：`50/100/500/1000/2000`条

   * 总条目数：显示在分页控件右侧（如`共160条`）
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956dcc0808c.png)


   * 支持输入页码跳转
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956dd13f5fb.png)




2. **排序**

   支持根据【文件名】、【大小】、【修改时间】进行排序。点击排序箭头，排序模式可在以下三种方式之间切换：

   * 倒序

   * 正序

   * 不排序
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956dd6bae2b.png)


##### **13.3.7 文件操作**

1. **单文件操作按钮**

| **按钮** | **功能说明**                       |
| ------ | ------------------------------ |
| 下载     | 保存到本地下载目录                      |
| 属性     | 显示文件类型、全路径（可复制）、大小、权限、时间戳等详细信息 |
| 更多∨    | 展开二级菜单（复制/剪切/删除/重命名/压缩/权限）     |
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956ddc689a3.png)


1. **关键功能说明**

   * **删除**：&#x20;

     * 弹窗确认：&#x20;

     > - "删除文件后，该文件将迁移至文件回收站，如需彻底删除请前往文件回收站，是否继续操作？"
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956de202265.png)


   * **压缩**：&#x20;

     * 支持格式：`tar.gz`/`zip`

     * 可选操作：压缩到指定路径 或 压缩后直接下载
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956de75daa5.png)


   * **权限编辑**：            &#x20;

   1. 可勾选所有者、用户组、公共三类权限，勾选后，下方“权限”处数字自动变更

   2. 也可通过下方的“权限”编辑数字，联动上方的选择框；

   3. 读 4 、写 2 、执行 1

   4. “权限”数字，每一位最大 7，固定长度 3 位，每一位都存在为 0 的可能

   5. 所有者：下拉选择，可选当前操作系统内所有用户

   6. 子目录：勾选后，则代表当前文件夹及子文件夹、文件设置同样权限
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956dec5be9b.png)




##### **13.3.8 注意事项**

文件夹大小需手动点击【计算】加载
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956df12b280.png)




### 1&#x34;**、系统配置-日志管理**

#### **14.1 适用范围**

适用于所有已适配的机型。

#### **14.2 功能简介**

该功能用于查看和下载实时域系统中的相关日志文件。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956df666a16.png)


#### **14.3 使用详情**

##### **14.3.1 主页面**

点击【系统配置】 → 【日志管理】，可以查看实时域系统中的主要日志文件。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956dfb4c616.png)


##### **14.3.2 日志分类**

* 【System】：显示 kernel 日志。

* 【Service】：显示 daemon 日志。

* 【Runtime】：显示 RTE 日志。

* 【ALL】：显示所有日志文件。&#x20;

##### **14.3.3 单个下载**

a. 若要下载单个文件，选择需要下载的文件，点击对应的【下载】按钮即可。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e015a8ae.png)


b. 点击【下载】。

##### **14.3.4 批量下载**

a. 若要同时下载多个文件，可以通过点击文件前的复选框，选择多个文件，然后通过顶部的【下载】按钮进行批量下载。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e0fb6447.png)


**14.3.5 全部下载**

a. 若要一次性下载所有文件，可以通过点击标题栏前的复选框，选择所有文件，然后通过顶部的【下载】按钮进行批量下载。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e147af4d.png)


##### **14.3.6 排序**

支持根据【日志名称】或【修改时间】进行排序。点击【箭头】按钮，可以切换排序模式：

* 倒序

* 正序

* 不排序
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e19eac37.png)


##### **14.3.7 生成报告**

点击右上角【生成报告】
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e1f67074.png)


可在消息中心看到消息提示，根据消息提示中的路径可以去文件管理中下载报告
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e25c4fc3.png)
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e2a0ad86.png)


##### **14.3.8 注意事项**

* 请在非生产环境下进行批量下载。



### 15、系统配置-系统防火墙

#### **15.1 防火墙开关控制**

**15.1.1 开启防火墙**
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e30802d5.png)


**15.1.2 关闭防火墙**

弹窗提示确认操作风险
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e3603322.png)


#### **15.2 添加新规则**

点击右上角【添加规则】
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e3b5005a.png)


按提示输入规则信息，点击【确定】可以进行添加
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e3f900a2.png)


#### **15.3 规则编辑与删除**

![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e4c3b387.png)

![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e5238809.png)
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e56931a3.png)


### 1&#x36;**、系统配置-时间管理**

#### **16.1 适用范围**

适用于所有已适配的机型。

#### **16.2 功能简介**

该功能用于修改实时域系统的时区、日期和时间设置。

#### **16.3 使用详情**

##### **16.3.1 主页面**

点击左侧列表中的【系统配置】 → 【时间管理】，在当前页面可以查看系统时区、日期和时间，并提供【编辑】按钮进行修改。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e6114a06.png)


> 时间设置不支持自动实时更新，需手动刷新页面以查看。

##### **16.3.2 修改时区**

a. 点击【编辑】按钮后，您可以修改时区，根据现场需求选择合适的时区。
b. 完成配置修改后，点击【保存】按钮以使设置生效。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e66a68e7.png)


##### **16.3.3 修改日期**

a. 点击【编辑】按钮后，您可以修改日期，根据实际需求选择所需日期。（点击【今天】可选择）
b。 使用下拉框中的'<<'或'>>'双箭头按年向前/后调整，使用'<'或'>'单箭头按月向前/后调整。
c. 完成日期修改后，点击【保存】按钮以使设置生效。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e6b9179c.png)


##### **16.3.4 修改时间**

a. 点击【编辑】按钮后，您可以修改时间，根据实际需求选择相应的时间。
b. 在下拉框中选择所需时间，点击【确定】按钮以使设置生效。
c. 完成时间修改后，点击【保存】按钮以使设置生效。
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e708a86b.png)


##### **16.3.5 注意事项**

* 时间不支持自动实时变化，需手动刷新页面以查看最新设置。

* 即使只修改了部分配置，最终生效的配置以页面上显示的时区、日期和时间为准，且必须点击确认保存更改。

* 在非生产环境下进行配置修改时。



## 附录

### 一、错误诊断

软件中多数遇到的问题可以通过如下两种方式解决

a. 退出登录
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e799de0c.png)


b. 刷新
按【F12】进入如下界面
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e7f8f81e.png)

右键【刷新】按键选择【硬性重新加载】
![](https://resource.helplook.net/docker_production/3648ne/article/qW7X2pjy/68956e85a6b49.png)